package edu.unl.consystlab.sudokuSolver;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.JButton;


public class consistencyButtonHandler implements ActionListener, MouseListener {

	private sudokuInterface parentInterface;

	//default constructor //not used
	public consistencyButtonHandler()
	{
		
	}
	
	public consistencyButtonHandler(sudokuInterface new_interface)
	{
		parentInterface = new_interface;
	}
	
	public void mousePressed(MouseEvent e)
	{
		String[] actionCode = new String[4];
		//the format of the actionCommand is char;char;numeral[;numeral]
		//the first char is either b for binary or a for all diff.
		//the second char is either l for line c for column or u for unit
		//the first numeral is the line or column the second optional numeral
		//is used only if it is a unit then the two numerals give the line and column
		//numbers respectively of the unit.
		actionCode = ((JButton)e.getComponent()).getActionCommand().split(";");
		
		//We dont care wether it is binary or not we are just highligting an area.
		if(actionCode[1].equals("l"))
		{
			parentInterface.depressLine(Integer.parseInt(actionCode[2]));
		}
		else if (actionCode[1].equals("c"))
		{
			parentInterface.depressColumn(Integer.parseInt(actionCode[2]));				
		}
		else if (actionCode[1].equals("u"))
		{
			parentInterface.depressUnit(Integer.parseInt(actionCode[2]),Integer.parseInt(actionCode[3]));				
		}
	}
	public void mouseReleased(MouseEvent e)
	{
		String[] actionCode = new String[4];
		//the format of the actionCommand is char;char;numeral[;numeral]
		//the first char is either b for binary or a for all diff.
		//the second char is either l for line c for column or u for unit
		//the first numeral is the line or column the second optional numeral
		//is used only if it is a unit then the two numerals give the line and column
		//numbers respectively of the unit.
		actionCode = ((JButton)e.getComponent()).getActionCommand().split(";");
		
		//We dont care wether it is binary or not we are just highligting an area.
		if(actionCode[1].equals("l"))
		{
			parentInterface.undepressLine(Integer.parseInt(actionCode[2]));
		}
		else if (actionCode[1].equals("c"))
		{
			parentInterface.undepressColumn(Integer.parseInt(actionCode[2]));				
		}
		else if (actionCode[1].equals("u"))
		{
			parentInterface.undepressUnit(Integer.parseInt(actionCode[2]),Integer.parseInt(actionCode[3]));				
		}
	}
	public void mouseEntered(MouseEvent e)
	{
	}
	public void mouseExited(MouseEvent e)
	{
	}
	public void mouseClicked(MouseEvent e)
	{
	}

	//the format of the actionCommand is char;char;numeral[;numeral]
	//the first char is either b for binary or a for all diff.
	//the second char is either l for line c for column or u for unit
	//the first numeral is the line or column the second optional numeral
	//is used only if it is a unit then the two numerals give the line and column
	//numbers respectively of the unit.
	public void actionPerformed(ActionEvent e)
	{
		String[] actionCode = new String[4];
		actionCode = e.getActionCommand().split(";");
		
		if(actionCode[0].equals("b"))
		{
			if(actionCode[1].equals("l"))
			{
				parentInterface.binaryLineArcConsistency(Integer.parseInt(actionCode[2]));
			}
			else if (actionCode[1].equals("c"))
			{
				parentInterface.binaryColArcConsistency(Integer.parseInt(actionCode[2]));				
			}
			else if (actionCode[1].equals("u"))
			{
				parentInterface.binaryUnitArcConsistency(Integer.parseInt(actionCode[2]),Integer.parseInt(actionCode[3]));				
			}
		}
		else if(actionCode[0].equals("a"))
		{
			if(actionCode[1].equals("l"))
			{
				parentInterface.alldifLineArcConsistency(Integer.parseInt(actionCode[2]));
			}
			else if (actionCode[1].equals("c"))
			{
				parentInterface.alldifColumnArcConsistency(Integer.parseInt(actionCode[2]));				
			}
			else if (actionCode[1].equals("u"))
			{
				parentInterface.alldifUnitArcConsistency(Integer.parseInt(actionCode[2]),Integer.parseInt(actionCode[3]));				
			}
		}

	}
	public void buttonPressed()
	{
		
	}
}